<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title>Sihpay Login</title>

    <!-- PWA manifest -->
    <link rel="manifest" href="../mobile/manifest.json">
    <meta name="theme-color" content="#000000">

    <!-- Service Worker -->
    <script>
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('../mobile/sw.js');
        }
    </script>

    <link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">
    <link rel="icon" type="image/png" href="../../assets/img/favicon.png" />

    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #0d0d0d;
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            transition: background 0.3s, color 0.3s;
        }
        .login-container {
            width: 100%;
            max-width: 400px;
            padding: 30px;
            background: #1a1a1a;
            border-radius: 16px;
            box-shadow: 0px 8px 25px rgba(0, 0, 0, 0.6);
            transition: background 0.3s, color 0.3s;
            position: relative;
        }
        .login-logo {
            text-align: center;
            margin-bottom: 25px;
        }
        .login-logo img {
            width: 70px;
            margin-bottom: 10px;
        }
        .login-logo h1 {
            font-size: 22px;
            font-weight: 700;
            color: #fff;
        }
        .form-control {
            background: #111;
            border: 1px solid #333;
            border-radius: 12px;
            padding: 15px 45px 15px 15px;
            color: #fff;
            transition: background 0.3s, color 0.3s, border 0.3s;
        }
        .form-control:focus {
            border-color: <?php echo $sitecolor; ?>;
            box-shadow: 0px 0px 6px <?php echo $sitecolor; ?>66;
        }
        .input-style {
            position: relative;
            margin-bottom: 20px;
        }
        .input-style i {
            position: absolute;
            top: 50%;
            right: 15px;
            transform: translateY(-50%);
            color: #aaa;
        }
        .btn-login {
            width: 100%;
            padding: 14px;
            border-radius: 12px;
            background: linear-gradient(135deg, <?php echo $sitecolor; ?>, <?php echo $sitecolor; ?>cc);
            border: none;
            color: #fff;
            font-weight: 600;
            font-size: 16px;
            transition: all .3s;
        }
        .btn-login:hover {
            opacity: 0.9;
        }
        .login-links {
            text-align: center;
            margin-top: 20px;
        }
        .login-links a {
            display: block;
            margin: 6px 0;
            font-size: 14px;
            color: <?php echo $sitecolor; ?>;
            font-weight: 500;
        }

        /* Theme toggle icon */
        .theme-toggle {
            position: absolute;
            top: 15px;
            right: 15px;
            background: none;
            border: none;
            color: #fff;
            font-size: 20px;
            cursor: pointer;
            transition: color 0.3s;
        }

        /* Toast styling */
        #toast {
            visibility: hidden;
            min-width: 220px;
            max-width: 90%;
            background: #222;
            color: #fff;
            text-align: center;
            border-radius: 8px;
            padding: 12px 16px;
            position: fixed;
            z-index: 9999;
            left: 50%;
            bottom: 30px;
            transform: translateX(-50%);
            font-size: 14px;
            font-weight: 500;
            opacity: 0;
            transition: opacity 0.4s, bottom 0.4s;
        }
        #toast.show {
            visibility: visible;
            opacity: 1;
            bottom: 50px;
        }

        /* Light theme styles */
        body.light-mode {
            background: #f7f7f7;
            color: #000;
        }
        .light-mode .login-container {
            background: #fff;
            box-shadow: 0px 8px 25px rgba(0, 0, 0, 0.1);
        }
        .light-mode .form-control {
            background: #f0f0f0;
            border: 1px solid #ccc;
            color: #000;
        }
        .light-mode .login-logo h1 {
            color: #000;
        }
        .light-mode .input-style i {
            color: #666;
        }
        .light-mode .theme-toggle {
            color: #333;
        } 
        /* Adjust button text color in light theme */
.light-mode .btn-login {
    color: #000;
}

        @media(max-width: 480px) {
            .login-container {
                margin: 0 15px;
                padding: 25px;
            }
        }
    </style>
</head>

<body>
    <div class="login-container">
        <!-- Theme toggle icon -->
        <button id="theme-toggle" class="theme-toggle" title="Switch Theme"><i class="fa fa-moon"></i></button>

        <div class="login-logo">
            <img src="../../assets/img/favicon.png" alt="Logo">
            <h1><?php echo $sitename; ?></h1>
            <p id="accountname">Welcome back!</p>
        </div>

        <form id="login-form" method="post">
            <div class="input-style" id="phonediv">
                <input type="number" class="form-control" id="phonelogin" name="phone" placeholder="Phone Number" required>
                <i class="fa fa-phone"></i>
            </div>
            <div class="input-style">
                <input type="password" class="form-control" id="passwordlogin" name="password" placeholder="Password" required>
                <i class="fa fa-lock"></i>
            </div>

            <input type="hidden" id="deviceid" name="device" value="1723476891xlrsFkvJDq963" />

            <button type="submit" id="submit-btn" class="btn-login">Login</button>
        </form>

        <div class="login-links">
            <a href="../recovery/">Forgot Password?</a>
            <a href="../register/">New User? Create Account</a>
        </div>
    </div>

    <!-- Toast -->
    <div id="toast"></div>

    <!-- JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            checkIfPhoneNumberSaved();

            // Theme toggle
            const themeToggle = document.getElementById("theme-toggle");
            const body = document.body;

            // Load saved theme
            const savedTheme = localStorage.getItem("theme");
            if (savedTheme === "light") {
                body.classList.add("light-mode");
                themeToggle.innerHTML = '<i class="fa fa-sun"></i>';
            }

            themeToggle.addEventListener("click", () => {
                body.classList.toggle("light-mode");
                if (body.classList.contains("light-mode")) {
                    themeToggle.innerHTML = '<i class="fa fa-sun"></i>';
                    localStorage.setItem("theme", "light");
                } else {
                    themeToggle.innerHTML = '<i class="fa fa-moon"></i>';
                    localStorage.setItem("theme", "dark");
                }
            });

            $('#login-form').submit(function(e) {
                e.preventDefault();
                $('#submit-btn').html('<i class="fa fa-spinner fa-spin"></i> Processing...');
                $.ajax({
                    url: '../home/includes/route.php?login',
                    data: new FormData($(this)[0]),
                    cache: false,
                    contentType: false,
                    processData: false,
                    method: 'POST',
                    success: function(resp) {
                        resp = JSON.parse(resp);
                        if (resp.status == "success") {
                            showToast("Login successful — redirecting...");
                            setTimeout(function() {
                                location.replace('../home/')
                            }, 1500);
                        } else {
                            showToast("Login failed: " + resp.msg);
                        }
                        $('#submit-btn').html("Login");
                    },
                    error: function() {
                        showToast("Error: Unable to connect to server");
                        $('#submit-btn').html("Login");
                    }
                });
            });
        });

        function showToast(message) {
            let toast = document.getElementById("toast");
            toast.innerText = message;
            toast.className = "show";
            setTimeout(function() {
                toast.className = toast.className.replace("show", "");
            }, 2500);
        }

        function checkIfPhoneNumberSaved() {
            let phone = atob(unescape(getCookie("loginPhone")));
            let name = atob(unescape(getCookie("loginName")));
            if (phone && phone !== "") {
                $("#accountname").html("Welcome back, " + name + "!");
                let msg = '<a href="javascript:showNumber();">Login with another account?</a>';
                $("#accountname").after(msg);
                $("#phonediv").hide();
                $("#phonelogin").val(phone);
            }
        }

        function showNumber() { $("#phonediv").show(); }
        function getCookie(cname) {
            var name = cname + "=";
            var ca = document.cookie.split(';');
            for (var i = 0; i < ca.length; i++) {
                var c = ca[i].trim();
                if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
            }
            return "";
        }
    </script>
</body>
</html>