<!DOCTYPE HTML>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title>Register</title>
    
    <!-- Link to the external stylesheets (same as login page) -->
    <link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">
    
    <link rel="manifest" href="../assets/scripts/_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
    <link rel="icon" type="image/png" href="../../assets/img/favicon.png" />
</head>
<style>
    body {
        background: linear-gradient(#000099, #3333ff);
        background-image: url("../../assets/img/bg/cover7.jpg");
        background-position: center center;
        -webkit-background-size: cover;
        -moz-background-size: cover;
        background-size: cover;
        -o-background-size: cover;
        background-repeat: no-repeat;
        background-attachment: fixed;
    }

    #loginContainerContent {
        margin-top: 20vh;
        margin-bottom: 10px;
        text-align: left;
        color: #000;
        font-weight: 600;
    }

    .brand_logo_container {
        margin-top: -120px;
        margin-bottom: 20px;
        padding: 10px;
    }

    .brand_logo {
        height: 150px;
        width: 155px;
        text-align: center;
    }

    .position {
        max-width: 400px;
        height: auto;
        margin: auto;
        position: relative;
    }

    .user_card {
        background: rgba(255, 255, 255, 0.9);
        padding: 30px;
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, .2), 0 6px 20px 0 rgba(0, 0, 0, .19);
        border-radius: 2rem;
        color: #000;
    }

    h3 {
        color: #000;
        text-align: left;
        font-weight: 600;
    }

    .loginbtn {
        border-radius: 1rem;
    }

    .form-control {
        border-radius: 1rem;
    }

    #pindiv {
        display: none;
    }
</style>

<body>

    <div class="container">
        <div id="loginContainerContent">
            <div class="position user_card">
                <div>
                    <div align="center" class="brand_logo_container">
                        <img src="../../assets/img/login.png" alt="Logo" class="brand_logo" />
                    </div>
                    <h5 class="text-center"><b id="accountname">Register</b></h5>
                    <hr />

                    <form id="reg-form" method="post">
                        <div class="text-center">
                            
                            <!-- First Name -->
                            <div class="form-group mb-3">
                                <input type="text" class="form-control" id="fname" name="fname" placeholder="First Name" required />
                            </div>

                            <!-- Last Name -->
                            <div class="form-group mb-3">
                                <input type="text" class="form-control" id="lname" name="lname" placeholder="Last Name" required />
                            </div>

                            <!-- Phone Number -->
                            <div class="form-group mb-3">
                                <input type="number" class="form-control" id="phone" name="phone" placeholder="Phone Number" required />
                            </div>

                            <!-- Email -->
                            <div class="form-group mb-3">
                                <input type="email" class="form-control" id="email" name="email" placeholder="Email" required />
                            </div>

                            <!-- State -->
                            <div class="form-group mb-3">
                                <select class="form-control" id="state" name="state" required>
                                    <option value="" selected disabled>State</option>
                                    <option value="Abuja FCT" style="color:#000000 !important;">Abuja FCT</option>
                                            <option value="Abia" style="color:#000000 !important;">Abia</option>
                                            <option value="Adamawa" style="color:#000000 !important;">Adamawa</option>
                                            <option value="Akwa Ibom" style="color:#000000 !important;">Akwa Ibom</option>
                                            <option value="Anambra" style="color:#000000 !important;">Anambra</option>
                                            <option value="Bauchi" style="color:#000000 !important;">Bauchi</option>
                                            <option value="Bayelsa" style="color:#000000 !important;">Bayelsa</option>
                                            <option value="Benue" style="color:#000000 !important;">Benue</option>
                                            <option value="Borno" style="color:#000000 !important;">Borno</option>
                                            <option value="Cross River" style="color:#000000 !important;">Cross River</option>
                                            <option value="Delta" style="color:#000000 !important;">Delta</option>
                                            <option value="Ebonyi" style="color:#000000 !important;">Ebonyi</option>
                                            <option value="Edo" style="color:#000000 !important;">Edo</option>
                                            <option value="Ekiti" style="color:#000000 !important;">Ekiti</option>
                                            <option value="Enugu" style="color:#000000 !important;">Enugu</option>
                                            <option value="Gombe" style="color:#000000 !important;">Gombe</option>
                                            <option value="Imo" style="color:#000000 !important;">Imo</option>
                                            <option value="Jigawa" style="color:#000000 !important;">Jigawa</option>
                                            <option value="Kaduna" style="color:#000000 !important;">Kaduna</option>
                                            <option value="Kano" style="color:#000000 !important;">Kano</option>
                                            <option value="Katsina" style="color:#000000 !important;">Katsina</option>
                                            <option value="Kebbi" style="color:#000000 !important;">Kebbi</option>
                                            <option value="Kogi" style="color:#000000 !important;">Kogi</option>
                                            <option value="Kwara" style="color:#000000 !important;">Kwara</option>
                                            <option value="Lagos" style="color:#000000 !important;">Lagos</option>
                                            <option value="Nassarawa" style="color:#000000 !important;">Nassarawa</option>
                                            <option value="Niger" style="color:#000000 !important;">Niger</option>
                                            <option value="Ogun" style="color:#000000 !important;">Ogun</option>
                                            <option value="Ondo" style="color:#000000 !important;">Ondo</option>
                                            <option value="Osun" style="color:#000000 !important;">Osun</option>
                                            <option value="Oyo" style="color:#000000 !important;">Oyo</option>
                                            <option value="Plateau" style="color:#000000 !important;">Plateau</option>
                                            <option value="Rivers" style="color:#000000 !important;">Rivers</option>
                                            <option value="Sokoto" style="color:#000000 !important;">Sokoto</option>
                                            <option value="Taraba" style="color:#000000 !important;">Taraba</option>
                                            <option value="Yobe" style="color:#000000 !important;">Yobe</option>
                                            <option value="Zamfara" style="color:#000000 !important;">Zamfara</option>
                                    <!-- Add your state options here -->
                                </select>
                            </div>
                            

                            <!-- Password -->
                            <div class="form-group mb-3">
                                <input type="password" class="form-control" id="password" name="password" placeholder="Password" required />
                            </div>

                            <!-- Confirm Password -->
                            <div class="form-group mb-3">
                                <input type="password" class="form-control" id="cpassword" name="cpassword" placeholder="Confirm Password" required />
                            </div>

                            <!-- Transaction Pin -->
                            <div class="form-group mb-3">
                                <input type="number" class="form-control" id="transpin" name="transpin" placeholder="Transaction Pin" required />
                            </div>

                            <button type="submit" class="btn btn-full btn-l font-600 font-15 gradient-highlight mt-4 rounded-s">
                                Register
                            </button>
                        </div>
                    </form>

                    <div class="row pt-3 mb-3">
                        <div class="col-12 text-center font-15 mt-2">
                            <a href="../login/">Already Have An Account? <b>Login Now</b></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page content ends here -->
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script type="text/javascript" src="../assets/scripts/bootstrap.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script type="text/javascript" src="../assets/scripts/custom.js"></script>

<script type="text/javascript">
$("document").ready(function(){

    //Enable Form Input
    $("#email").click(function(){$(this).removeAttr("readonly"); });
    $("#phone").click(function(){$(this).removeAttr("readonly"); });
    $("#password").click(function(){$(this).removeAttr("readonly"); });
    $("#cpassword").click(function(){$(this).removeAttr("readonly"); });

    //Next Btn
    $("#next-btn").click(function(){
        
        $msg="";
        
        $('#next-btn').removeClass("gradient-highlight");
        $('#next-btn').addClass("btn-secondary");
        $('#next-btn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');
            
        
        if($("#account").val() == "" || $("#account").val() == " "){$msg="Please Select Account Type.";}
        if($("#email").val() == "" || $("#email").val() == " "){$msg="Please Enter Email.";}
        if($("#phone").val() == "" || $("#phone").val() == " "){$msg="Please Enter Phone Number.";}
        if($("#lname").val() == "" || $("#lname").val() == " "){$msg="Please Enter Last Name.";}
        if($("#fname").val() == "" || $("#fname").val() == " "){$msg="Please Enter First Name.";}
        
        

        if($msg != ""){
            
            swal("Alert!!",$msg,"info");

            $('#next-btn').removeClass("btn-secondary");
            $('#next-btn').addClass("gradient-highlight");
            $('#next-btn').html("Continue");
            
            return;
        }

        $("#regDiv").hide();
        $("#nextregDiv").show();

    });


    //Registration Form
    $('#reg-form').submit(function(e){
            e.preventDefault();
            $msg=""; 
            if($("#password").val().length > 15){$msg="Password should not be more than 15 character.";}
            if($("#password").val().length < 8){$msg="Password should be at least 8 character.";}
           
            if($("#password").val() == $("#phone").val()){$msg="You can't use your phone number as password.";}
            if($("#password").val() == "" || $("#password").val() == " "){$msg="Please Enter Password.";}
            if($("#state").val() == "" || $("#state").val() == " "){$msg="Please Select State.";}
            if(($("#password").val()) != ($("#cpassword").val())){$msg="Password Is Different From Confirm Password.";}
            if($("#transpin").val().length != 4){$msg="Please enter a 4 digit pin";}

            if($msg != ""){swal("Alert!!",$msg,"info");  $msg=""; return; }
            
            $('#submit-btn').removeClass("gradient-highlight");
            $('#submit-btn').addClass("btn-secondary");
            $('#submit-btn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');
            
            $.ajax({
                url:'../home/includes/route.php?register',
                data: new FormData($(this)[0]),
                cache: false,
                contentType: false,
                processData: false,
                method: 'POST',
                type: 'POST',
                success:function(resp){
                    
                    resp = JSON.parse(resp);

                    if(resp.status == "success"){
                        swal('Alert!!',"Registration Succesfull","success");
                        setTimeout(function(){
                            location.replace('../home/')
                        },1000);
                    }
                    else{
                        swal('Alert!!',resp.msg,"error");
                        $("#nextregDiv").hide(); $("#regDiv").show();
                   }

                   $('#submit-btn').removeClass("btn-secondary");
                   $('#submit-btn').addClass("gradient-highlight");
                   $('#submit-btn').html("Register");

                   $('#next-btn').removeClass("btn-secondary");
                   $('#next-btn').addClass("gradient-highlight");
                   $('#next-btn').html("Register");

                }
            })
        });
});
</script>

</body>
</html>
    